local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
end


// window init.
function PANEL:Init( )
	//
	self.LinkedClass = nil;
	
	// material
	self.Material = nil;
	
end

// set material
function PANEL:SetMaterial( mat )
	// get texture id.
	self.Material = surface.GetTextureID( mat );
	
end

// paint.
function PANEL:Paint( )
	// no icon!
	if( !self.Material ) then return; end
	
	// draw icon
	surface.SetDrawColor( 255, 255, 255, 255 );
	surface.SetTexture( self.Material );
	surface.DrawTexturedRect(
		0, 0,
		self:GetWide(), self:GetTall()
	);
	
	return true;
end

// register.
vgui.Register( "ctl_icon", PANEL, "Panel" );
